% Read input points
point = load('points.txt');
siz = size(point);

% Angles between 2 points in radian
angle = 10.384 * ones(siz(1),1) * pi / 180;

% Initial parameter of principal point
cxy0 = [360 240];

% Compute intrinsic parameter K
K = paracalib1(point, angle, cxy0)

% Compute RMS error of reprojection in pixels
rms = paracalib1_compute_error(K, point, angle)

% Visualization of error and degeneracy
% Symbolic Math Toolbox is required for visualization

% imgsize = [ysize xsize fmin fmax] is used for the range of plotting
imgsize = [520 780 500 800];
if license('checkout', 'symbolic_toolbox')
  compute_surface;
else
  disp('Symbolic Math Toolbox is required for visualization');
end
