imgfilenames = ['undist/distant_01_undist.png';
                'undist/distant_02_undist.png';
                'undist/distant_03_undist.png';
                'undist/distant_04_undist.png';
                'undist/distant_05_undist.png'];
pointfilenames = ['image_points_01.txt';
                  'image_points_02.txt';
                  'image_points_03.txt';
                  'image_points_04.txt';
                  'image_points_05.txt'];

siz = size(imgfilenames);

for m = 1:siz(1)
  img = imread(imgfilenames(m,:));
  points = load(pointfilenames(m,:));

  figure
  hold on
  image(img);
  axis('image');
  set(gca,'YDir','reverse')
  % point data are zero-origin
  % MATLAB is one-origin
  plot(points(:,1)+1,points(:,2)+1, 'rx', 'MarkerSize',8);
end
